<?xml version="1.0" encoding="utf-8"?>
<!--================================================================================-->
<!--

	Plik wizualizacji Edytora Aktów Prawnych XML
	(C)2002-2009 Administration & Business Consulting	
	Wszelkie prawa zastrzeżone.
	http://abc-grytner.pl
	
	Autor: (C)2009 ITORG Krzysztof Radzimski
	http://itorg.pl

	Elektroniczna postać aktu prawnego.
	Zgodnie ze strukturą zdefiniowaną
	w schemacie dostępnym pod adresem: http://epuap.gov.pl/wps/portal/epuap/pi
-->
<!--================================================================================-->
<xsl:stylesheet version="2.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:msxsl="urn:schemas-microsoft-com:xslt"
				exclude-result-prefixes="msxsl"
				xmlns="http://www.w3.org/1999/xhtml"
				xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
				xmlns:xs="http://www.w3.org/2001/XMLSchema"
				xmlns:my="http://itorg.pl/my-xmlt-functions"
				xmlns:saxon="http://saxon.sf.net/"
>
	<xsl:output method="xml"
				indent="yes"
				doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
				doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

	<xsl:variable name="header-type">
		<xsl:value-of select="'$HEADER_TYPE$'"/>
	</xsl:variable>

	<xsl:variable name="city-name">
		<xsl:value-of select="'$CITY_NAME$'"/>
	</xsl:variable>

	<xsl:variable name="header-is-caps">
		<xsl:value-of select="$HEADER_IS_CAPS$"/>
	</xsl:variable>


	<xsl:variable name="AttachmentTitle" >
		<xsl:for-each select="/">
			<xsl:for-each select="*">
				<xsl:for-each select="metryczka">

					<xsl:choose>
						<xsl:when test="@nazwa = 'ustawa'">
							<xsl:value-of select="'Ustawy'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'rozporzadzenie'">
							<xsl:value-of select="'Rozporządzenia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'uchwala'">
							<xsl:value-of select="'Uchwały'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'zarzadzenie'">
							<xsl:value-of select="'Zarządzenia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'informacja'">
							<xsl:value-of select="'Informacji'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'komunikat'">
							<xsl:value-of select="'Komunikatu'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'decyzja'">
							<xsl:value-of select="'Decyzji'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'oswiadczenie'">
							<xsl:value-of select="'Oświadczenia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'postanowienie'">
							<xsl:value-of select="'Postanowienia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'wyrok'">
							<xsl:value-of select="'Wyroku'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'porozumienie'">
							<xsl:value-of select="'Porozumienia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'ogloszenie'">
							<xsl:value-of select="'Ogłoszenia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'obwieszczenie'">
							<xsl:value-of select="'Obwieszczenia'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'aneks'">
							<xsl:value-of select="'Aneksu'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'statut'">
							<xsl:value-of select="'Statutu'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'sprawozdanie'">
							<xsl:value-of select="'Sprawozdania'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'protokol'">
							<xsl:value-of select="'Protokółu'"/>
						</xsl:when>
						<xsl:when test="@nazwa = 'umowa'">
							<xsl:value-of select="'Umowy'"/>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="@numer != ''">
						<xsl:value-of select="' Nr '"/>
						<xsl:value-of select="@numer"/>
					</xsl:if>


					<xsl:if test="@organ-wydajacy != '' and @nazwa != 'umowa'">
						<br/>
						<xsl:value-of select="@organ-wydajacy"/>
					</xsl:if>

					<xsl:if test="@data != '1-01-01T00:00:00Z'">
						<br/>
						<xsl:value-of select="'z dnia '"/>
						<xsl:call-template name="date-name">
							<xsl:with-param name="ADate" select="@data"/>
						</xsl:call-template>
					</xsl:if>

				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:variable>

	<xsl:template match="/">

		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>
					<xsl:for-each select="*">
						<xsl:for-each select="metryczka">
							<xsl:value-of select="'Uchwała'"/>
							<xsl:value-of select="' Nr. '"/>
							<xsl:value-of select="@numer"/>
						</xsl:for-each>
					</xsl:for-each>
				</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<meta name="generator" content="Edytor Aktów Prawnych XML (C)2002-2009 Administration And Business Consulting" />
				<style type="text/css">
					a { text-decoration:none; color:blue;}
					a:hover { text-decoration:underline; color:blue;}
					a:visited { text-decoration:none; color:blue;}
					body {
					background-color: white;
					font-size: $BODY_FONT_SIZE$;
					font-family: $BODY_FONT_FAMILY$;
					border: 0px;
					margin-top: 0px;
					margin-left: 0px;
					margin-right: 0px;
					margin-bottom: 0px;
					padding: 0px;
					width: 100%;
					text-align: $BODY_TEXT_ALIGN$;
					}
					div {line-height: $BODY_TEXT_LINE_HEIGHT$;}

					.MainPanel2
					{
					margin: auto;
					width: $PAGE_WIDTH$cm;

					padding-left: $MARGIN_LEFT$cm;
					padding-right: $MARGIN_RIGHT$cm;

					padding-bottom: $MARGIN_BOTTOM$cm;
					padding-top: $MARGIN_TOP$cm;
					}

					.MainPanel2Printable
					{
					width: $PAGE_WIDTH$cm;

					padding-left: $MARGIN_LEFT$cm;
					padding-right: $MARGIN_RIGHT$cm;

					padding-bottom: $MARGIN_BOTTOM$cm;
					padding-top: $MARGIN_TOP$cm;
					}

					.MainPanelContent{
					}

					.preambula{text-indent: $BODY_ELEMENT_TEXT_INDENT$%; text-align: justify; margin-bottom: 20px;}
					.uzasadnienie{margin-bottom: 10px; margin-top: 10px; page-break-before: always; }
					.ksiega{margin-top: 25px; margin-bottom: 10px;}
					.czesc{margin-top: 25px; margin-bottom: 10px;}
					.tyt{margin-top: 25px; margin-bottom: 10px;}
					.oddzial{margin-bottom: 10px;}
					.dzial{margin-top: 25px; margin-bottom: 10px;}
					.srodtytul{text-align: center; font-weight: bold; margin-bottom: 10px; margin-top: 10px; }
					.rozdzial{margin-top: 25px; margin-bottom: 10px; font-weight: normal;}
					.artykul{text-indent: $BODY_ELEMENT_TEXT_INDENT$%; margin-bottom: 20px; font-weight: normal; }
					.paragraf{text-indent: $BODY_ELEMENT_TEXT_INDENT$%; margin-bottom: 20px; font-weight: normal; }
					.ustep{text-indent: $BODY_ELEMENT_TEXT_INDENT$%; }
					.punkt{margin-bottom: 5px; font-weight: normal;}
					.litera{margin-bottom: 5px; font-weight: normal;}
					.tiret{margin-bottom: 5px; font-weight: normal;}
					.akapit{ margin-bottom: 5px; text-indent: $BODY_SECTION_TEXT_INDENT$%; font-weight: normal;}
					.zalacznik_bin{width: 100%; margin-bottom: 20px; margin-top: 30px; page-break-before: always;}
					.zalacznik{width: 100%; margin-bottom: 30px; margin-top: 30px; page-break-before: always;}
					.tabela
					{
					margin-top: 10px;
					font-weight: normal;
					font-size: $TABLE_FONT_SIZE$;
					font-family: $TABLE_FONT_FAMILY$;
					border: 1px solid black;
					border-collapse: collapse;
					}
					.wiersz
					{
					}
					.komorka
					{
					border: 1px solid black;
					border-collapse: collapse;
					vertical-align: top;
					padding: 2px;
					}
				</style>
			</head>
			<body>
				<div class="MainPanel2">
					<div class="MainPanelContent">
						<xsl:attribute name="id">
							<xsl:for-each select="*">
								<xsl:value-of select="@id"/>
							</xsl:for-each>
						</xsl:attribute>

						<!--Informacja o projekcie-->
						<xsl:for-each select="*">
							<xsl:for-each select="metryczka">
								<xsl:if test="@status-aktu = 'projekt'">
									<div style="font-weight: normal; text-decoration: underline; font-style: italic; width: 100%; text-align: right;">
										<xsl:text>Projekt</xsl:text>
									</div>
									<br/>
									<br/>
									<br/>
								</xsl:if>
							</xsl:for-each>
						</xsl:for-each>

						<!--Lista aktów zmieniajacych-->
						<xsl:for-each select="*">
							<xsl:for-each select="metryczka">
								<xsl:for-each select="lista-aktow-zmieniajacych">
									<div style="font-size: 70%; text-align: justify; margin-bottom: 80px;">
										<b>
											<xsl:text>Zmiany:</xsl:text>
										</b>
										<ol>
											<xsl:for-each select="akt-zmieniajacy">
												<li>
													<a style="text-decoration: none; color: black;">
														<xsl:attribute name="href">
															<xsl:value-of select="@cel"/>
														</xsl:attribute>
														<xsl:value-of select="."/>
													</a>
												</li>
											</xsl:for-each>
										</ol>
									</div>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>

						<!-- Standardowy nagłówek aktu -->
						<xsl:if test="$header-type = 'S'">
							<div style="font-weight: bold; text-align: center; line-height: 25px;">
								<xsl:for-each select="*">
									<xsl:for-each select="metryczka">
										<span>
											<xsl:if test="$header-is-caps = true()">
												<xsl:attribute name="style">
													<xsl:text>font-variant: small-caps;</xsl:text>
												</xsl:attribute>
											</xsl:if>
											<xsl:choose>
												<xsl:when test="@nazwa = 'ustawa'">
													<xsl:value-of select="'Ustawa'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'rozporzadzenie'">
													<xsl:value-of select="'Rozporządzenie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'uchwala'">
													<xsl:value-of select="'Uchwała'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'zarzadzenie'">
													<xsl:value-of select="'Zarządzenie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'informacja'">
													<xsl:value-of select="'Informacja'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'komunikat'">
													<xsl:value-of select="'Komunikat'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'decyzja'">
													<xsl:value-of select="'Decyzja'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'oswiadczenie'">
													<xsl:value-of select="'Oświadczenie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'postanowienie'">
													<xsl:value-of select="'Postanowienie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'wyrok'">
													<xsl:value-of select="'Wyrok'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'porozumienie'">
													<xsl:value-of select="'Porozumienie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'ogloszenie'">
													<xsl:value-of select="'Ogłoszenie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'obwieszczenie'">
													<xsl:value-of select="'Obwieszczenie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'aneks'">
													<xsl:value-of select="'Aneks'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'statut'">
													<xsl:value-of select="'Statut'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'sprawozdanie'">
													<xsl:value-of select="'Sprawozdanie'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'protokol'">
													<xsl:value-of select="'Protokół'"/>
												</xsl:when>
												<xsl:when test="@nazwa = 'umowa'">
													<xsl:value-of select="'Umowa'"/>
												</xsl:when>
											</xsl:choose>
											<xsl:if test="@numer != ''">
												<xsl:value-of select="' Nr '"/>
												<xsl:choose>
													<xsl:when test="@status-aktu = 'projekt'">
														<span style="font-weight: normal;">
															<xsl:text>....................</xsl:text>
														</span>
													</xsl:when>
													<xsl:otherwise>
														<xsl:value-of select="@numer"/>
													</xsl:otherwise>
												</xsl:choose>

											</xsl:if>
										</span>
										<br />

										<xsl:if test="@organ-wydajacy != '' and @nazwa != 'umowa'">
											<span>
												<xsl:if test="$header-is-caps = true()">
													<xsl:attribute name="style">
														<xsl:text>font-variant: small-caps;</xsl:text>
													</xsl:attribute>
												</xsl:if>
												<xsl:value-of select="@organ-wydajacy"/>
											</span>
											<br />
										</xsl:if>

										<xsl:if test="@data != '1-01-01T00:00:00Z'">
											<span style="font-weight:normal;">
												<xsl:value-of select="'z dnia '"/>
												<xsl:choose>
													<xsl:when test="@status-aktu = 'projekt'">
														<xsl:text>....................&#160;</xsl:text>
														<xsl:call-template name="date-year">
															<xsl:with-param name="ADate" select="@data"/>
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="date-name">
															<xsl:with-param name="ADate" select="@data"/>
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</span>
											<br />
											<br />
										</xsl:if>
										<xsl:for-each select="tytul">
											<div style="font-weight:bold;">
												<!--<xsl:value-of select="."/>-->
												<xsl:apply-templates/>
											</div>
										</xsl:for-each>
									</xsl:for-each>
								</xsl:for-each>
							</div>
						</xsl:if>

						<!-- Nagłówek aktu jak dla decyzji -->
						<xsl:if test="$header-type = 'D'">
							<xsl:for-each select="*">
								<xsl:for-each select="metryczka">
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<tr>
											<td style="width: 50%; vertical-align: top; text-align: center;">
												<img src="orzel.png" alt=""/>
												<br/>
												<div>
													<xsl:choose>
														<xsl:when test="$header-is-caps = true()">
															<xsl:attribute name="style">
																<xsl:text>font-weight: bold; font-variant: small-caps;</xsl:text>
															</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="style">
																<xsl:text>font-weight: bold;</xsl:text>
															</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
													<xsl:if test="@organ-wydajacy != ''">
														<xsl:value-of select="@organ-wydajacy"/>
														<br />
													</xsl:if>
												</div>

												<xsl:if test="@numer != ''">
													<div>
														<xsl:value-of select="' Nr '"/>
														<xsl:choose>
															<xsl:when test="@status-aktu = 'projekt'">
																<span style="font-weight: normal;">
																	<xsl:text>....................</xsl:text>
																</span>
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="@numer"/>
															</xsl:otherwise>
														</xsl:choose>
													</div>
													<br />
													<br />
												</xsl:if>

											</td>
											<td style="width: 50%; vertical-align: top; text-align: right;">
												<xsl:value-of select="$city-name"/>
												<xsl:text>, </xsl:text>
												<xsl:if test="@data != '1-01-01T00:00:00Z'">
													<xsl:value-of select="'dnia '"/>
													<xsl:choose>
														<xsl:when test="@status-aktu = 'projekt'">
															<xsl:text>....................&#160;</xsl:text>
															<xsl:call-template name="date-year">
																<xsl:with-param name="ADate" select="@data"/>
															</xsl:call-template>
														</xsl:when>
														<xsl:otherwise>
															<xsl:call-template name="date-name">
																<xsl:with-param name="ADate" select="@data"/>
															</xsl:call-template>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
											</td>
										</tr>
									</table>
									<div style="font-variant: small-caps; font-weight: bold; text-align: center; line-height: 25px;">
										<xsl:choose>
											<xsl:when test="@nazwa = 'ustawa'">
												<xsl:value-of select="'Ustawa'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'rozporzadzenie'">
												<xsl:value-of select="'Rozporządzenie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'uchwala'">
												<xsl:value-of select="'Uchwała'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'zarzadzenie'">
												<xsl:value-of select="'Zarządzenie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'informacja'">
												<xsl:value-of select="'Informacja'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'komunikat'">
												<xsl:value-of select="'Komunikat'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'decyzja'">
												<xsl:value-of select="'Decyzja'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'oswiadczenie'">
												<xsl:value-of select="'Oświadczenie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'postanowienie'">
												<xsl:value-of select="'Postanowienie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'wyrok'">
												<xsl:value-of select="'Wyrok'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'porozumienie'">
												<xsl:value-of select="'Porozumienie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'ogloszenie'">
												<xsl:value-of select="'Ogłoszenie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'obwieszczenie'">
												<xsl:value-of select="'Obwieszczenie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'aneks'">
												<xsl:value-of select="'Aneks'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'statut'">
												<xsl:value-of select="'Statut'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'sprawozdanie'">
												<xsl:value-of select="'Sprawozdanie'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'protokol'">
												<xsl:value-of select="'Protokół'"/>
											</xsl:when>
											<xsl:when test="@nazwa = 'umowa'">
												<xsl:value-of select="'Umowa'"/>
											</xsl:when>
										</xsl:choose>
									</div>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:if>

						<br />
						<!-- akt -->
						<xsl:for-each select="*">
							<xsl:apply-templates/>
						</xsl:for-each>

						<!--podpisy-->
						<xsl:for-each select="*">
							<xsl:for-each select="podpisy">
								<xsl:for-each select="podpis">
									<div style="width: 100%; margin-bottom: 30px; margin-top: 80px;">
										<div style="text-align: center; width: $ATTACHMENT_WIDTH$%; float: right;">
											<xsl:attribute name="id">
												<xsl:value-of select="@oid"/>
											</xsl:attribute>

											<xsl:if test="@z-upowaznienia != ''">
												<xsl:value-of select="'Z upoważnienia'"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="@z-upowaznienia"/>
												<br/>
											</xsl:if>
											<xsl:if test="@funkcja != ''">
												<b>
													<xsl:call-template name="break">
														<xsl:with-param name="text" select="@funkcja"/>
													</xsl:call-template>
												</b>
												<br/>
												<br/>
												<br/>
												<br/>

											</xsl:if>
											<b>
												<xsl:if test="@tytul != ''">
													<xsl:value-of select="@tytul"/>
													<xsl:value-of select="' '"/>
												</xsl:if>
												<xsl:value-of select="@imie"/>
												<xsl:value-of select="' '"/>
												<xsl:value-of select="@nazwisko"/>
											</b>
										</div>
									</div>
								</xsl:for-each>
								<xsl:for-each select="lista">
									<div style="width: 100%; margin-bottom: 30px; margin-top: 50px;">
										<div style="width: $ATTACHMENT_WIDTH$%; float: right; text-align: left;">
											<xsl:attribute name="id">
												<xsl:value-of select="@oid"/>
											</xsl:attribute>
											<xsl:if test="@funkcja != ''">
												<b>
													<xsl:value-of select="@funkcja"/>
													<xsl:value-of select="': '"/>
												</b>
											</xsl:if>
											<xsl:for-each select="osoba">
												<div>
													<xsl:attribute name="id">
														<xsl:value-of select="@oid"/>
													</xsl:attribute>

													<xsl:value-of select="@imie"/>
													<xsl:value-of select="' '"/>
													<xsl:value-of select="@nazwisko"/>

													<xsl:if test="position() &lt; last()">
														<xsl:text>, </xsl:text>
													</xsl:if>
													<xsl:if test="position() = last()">
														<xsl:text>. </xsl:text>
													</xsl:if>

												</div>
											</xsl:for-each>
										</div>
									</div>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>

						<!--zalacznik_bin-->
						<xsl:for-each select="*">
							<xsl:for-each select="zalacznik_bin">
								<xsl:call-template name="zalacznik_bin"/>
							</xsl:for-each>
						</xsl:for-each>

						<!--Zalaczniki XML-->
						<xsl:for-each select="*">
							<xsl:for-each select="zalaczniki">
								<xsl:for-each select="*">
									<xsl:choose>
										<xsl:when test="contains(name(),'zalacznik_bin')">
											<xsl:call-template name="zalacznik_bin"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="zalacznik"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:for-each>

						<!-- Uzasadnienie -->
						<xsl:for-each select="*">
							<xsl:for-each select="uzasadnienie">
								<xsl:call-template name="uzasadnienie"/>
							</xsl:for-each>
						</xsl:for-each>

						<!--Treść przypisów-->
						<xsl:for-each select="*">
							<xsl:for-each select="tresc-przypisow">
								<div style="width: 100%; margin-top: 30px;">
									<xsl:attribute name="id">
										<xsl:value-of select="@oid"/>
									</xsl:attribute>
									<div style="border-top: solid 1px black; width: 30%;">
										<xsl:value-of select="' '"/>
									</div>
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<xsl:for-each select="tresc-przypisu">
											<tr>
												<td style="width: 5%; vertical-align: top;">
													<xsl:attribute name="id">
														<xsl:value-of select="@oid"/>
													</xsl:attribute>
													<a style="color: black; text-decoration: none;">
														<xsl:attribute name="name">
															<xsl:value-of select="'przypis'"/>
															<xsl:value-of select="@nr"/>
														</xsl:attribute>

														<sup>
															<xsl:value-of select="@nr"/>
															<xsl:value-of select="')'"/>
														</sup>
													</a>
												</td>
												<td style="width: 95%; vertical-align: top;">
													<xsl:apply-templates/>
												</td>
											</tr>
										</xsl:for-each>

									</table>
								</div>
							</xsl:for-each>
						</xsl:for-each>

						<!--Treść przypisów nowelizacyjnych-->
						<xsl:for-each select="*">
							<xsl:for-each select="tresc-przypisow-nowelizacyjnych">
								<div style="width: 100%; margin-top: 30px; font-size: 70%;">
									<div style="border-top: solid 1px black; width: 30%;">
										<xsl:value-of select="' '"/>
									</div>
									<table border="0" cellpadding="0" cellspacing="0" width="100%">
										<xsl:for-each select="tresc-przypisu">
											<tr>
												<td style="width: 5%; vertical-align: top;">
													<sup>
														<xsl:text>(</xsl:text>
														<xsl:value-of select="@nr"/>
														<xsl:text>)</xsl:text>
													</sup>
												</td>
												<td style="width: 95%; vertical-align: top;">
													<a style="color: black; text-decoration: none;">
														<xsl:attribute name="href">
															<xsl:value-of select="@cel"/>
														</xsl:attribute>
														<b>
															<xsl:choose>
																<xsl:when test="@status= 'zastap'">
																	<xsl:text>Zmiana: </xsl:text>
																</xsl:when>
																<xsl:when test="@status = 'dodaj'">
																	<xsl:text>Dodany: </xsl:text>
																</xsl:when>
																<xsl:when test="@status = 'uchyl'">
																	<xsl:text>Uchylony: </xsl:text>
																</xsl:when>
															</xsl:choose>
														</b>
														<xsl:apply-templates/>
													</a>
												</td>
											</tr>
										</xsl:for-each>

									</table>
								</div>
							</xsl:for-each>
						</xsl:for-each>
					</div>
				</div>
			</body>
		</html>

	</xsl:template>

	<!--preambula-->
	<xsl:template match="preambula">
		<div class="preambula">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--ksiega-->
	<xsl:template match="ksiega">
		<div class="ksiega">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; margin-bottom: 5px; font-variant: small-caps; margin-bottom: 10px; letter-spacing: 5px;">
				<xsl:value-of select="'Księga'"/>
				<xsl:value-of select="' '"/>
				<xsl:choose>
					<!--contains(number(@nr),'NaN')-->
					<xsl:when test="my:is-number(@nr)">
						<xsl:value-of select="@nr"/>
					</xsl:when>
					<xsl:otherwise >
						<xsl:choose>
							<xsl:when test="@nr = 1">
								Pierwsza
							</xsl:when>
							<xsl:when test="@nr = 2">
								Druga
							</xsl:when>
							<xsl:when test="@nr = 3">
								Trzecia
							</xsl:when>
							<xsl:when test="@nr = 4">
								Czwarta
							</xsl:when>
							<xsl:when test="@nr = 5">
								Piąta
							</xsl:when>
							<xsl:when test="@nr = 6">
								Szósta
							</xsl:when>
							<xsl:when test="@nr = 7">
								Siódma
							</xsl:when>
							<xsl:when test="@nr = 8">
								Ósma
							</xsl:when>
							<xsl:when test="@nr = 9">
								Dziewiąta
							</xsl:when>
							<xsl:otherwise>
								<xsl:number value="@nr" format="I"/>
							</xsl:otherwise>
						</xsl:choose>

					</xsl:otherwise>
				</xsl:choose>

				<xsl:for-each select="tytul">
					<br/>
					<!--<xsl:value-of select="."/>-->
					<xsl:apply-templates/>
				</xsl:for-each>
			</div>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--czesc-->
	<xsl:template match="czesc">
		<div class="czesc">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; font-variant: small-caps; margin-bottom: 10px; letter-spacing: 5px;">
				<xsl:value-of select="'Część'"/>
				<xsl:value-of select="' '"/>
				<xsl:choose>
					<!--contains(number(@nr),'NaN')-->
					<xsl:when test="my:is-number(@nr)">
						<xsl:value-of select="@nr"/>
					</xsl:when>
					<xsl:otherwise >
						<xsl:number value="@nr" format="I"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="'. '"/>
				<xsl:for-each select="tytul">
					<!--<xsl:value-of select="."/>-->
					<xsl:apply-templates/>
				</xsl:for-each>
			</div>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--uzasadnienie-->
	<xsl:template name="uzasadnienie">
		<div class="uzasadnienie">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; font-variant: small-caps; margin-bottom: 10px; letter-spacing: 5px;">
				<xsl:value-of select="'UZASADNIENIE'"/>
			</div>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--zalacznik_bin-->
	<xsl:template name="zalacznik_bin">
		<xsl:variable name="attachments-count" select="count(//zalaczniki/*)"/>

		<div class="zalacznik_bin">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="width: 100%;">
				<div style="text-align: left; width: $ATTACHMENT_WIDTH$%; float: right;">
					<xsl:choose>
						<xsl:when test="$attachments-count > 1">
							<b>
								<xsl:value-of select="'Załącznik nr'"/>
								<xsl:value-of select="' '"/>
								<xsl:choose>
									<!--<xsl:when test="contains(number(@nr),'NaN')">-->
									<!--<xsl:when test="number(@nr) = xs:float('NaN')">-->
									<xsl:when test="my:is-number(@nr)">
										<xsl:value-of select="@nr"/>
									</xsl:when>
									<xsl:otherwise >
										<xsl:number value="@nr"/>
									</xsl:otherwise>
								</xsl:choose>
							</b>
							<br/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'Załącznik'"/>
						</xsl:otherwise>
					</xsl:choose>

					<xsl:value-of select="' do '"/>
					<xsl:copy-of select="$AttachmentTitle"/>
					<xsl:if test="tytul != ''">
						<br/>
						<br/>
						<i>
							<xsl:for-each select="tytul">
								<xsl:value-of select="."/>
							</xsl:for-each>
						</i>
					</xsl:if>
					<br/>
					<a target="_blank">
						<xsl:attribute name="href">
							<xsl:value-of select="@nazwa"/>
						</xsl:attribute>
						<xsl:value-of select="@nazwa"/>
					</a>
				</div>
			</div>
		</div>
	</xsl:template>

	<!--zalacznik-->
	<xsl:template name="zalacznik">
		<xsl:variable name="attachments-count" select="count(//zalaczniki/*)"/>

		<div class="zalacznik">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="width: 100%; margin-bottom: 20px;">
				<div style="text-align: left; width: $ATTACHMENT_WIDTH$%; float: right;">
					<xsl:choose>
						<xsl:when test="$attachments-count > 1">
							<b>
								<xsl:value-of select="'Załącznik nr'"/>
								<xsl:value-of select="' '"/>
								<xsl:choose>
									<!--<xsl:when test="contains(number(@nr),'NaN')">-->
									<xsl:when test="my:is-number(@nr)">
										<xsl:value-of select="@nr"/>
									</xsl:when>
									<xsl:otherwise >
										<xsl:number value="@nr"/>
									</xsl:otherwise>
								</xsl:choose>
							</b>
							<br/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'Załącznik'"/>
						</xsl:otherwise>
					</xsl:choose>

					<xsl:value-of select="' do '"/>
					<xsl:copy-of select="$AttachmentTitle"/>
				</div>
			</div>
			<xsl:for-each select="tytul">
				<div style="text-align: center; font-weight: bold; margin-bottom: 15px; font-variant: small-caps;">
					<xsl:apply-templates/>
				</div>
			</xsl:for-each>

			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--tyt-->
	<xsl:template match="tyt">
		<div class="tyt">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; margin-bottom: 5px; font-variant: small-caps; margin-bottom: 10px; letter-spacing: 5px;">
				<xsl:value-of select="'Tytuł'"/>
				<xsl:value-of select="' '"/>
				<xsl:choose>
					<!--<xsl:when test="contains(number(@nr),'NaN')">-->
					<xsl:when test="my:is-number(@nr)">
						<xsl:value-of select="@nr"/>
					</xsl:when>
					<xsl:otherwise >
						<xsl:number value="@nr" format="I"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="'. '"/>
				<xsl:for-each select="tytul">
					<!--<xsl:value-of select="."/>-->
					<xsl:apply-templates/>
				</xsl:for-each>
			</div>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--dzial-->
	<xsl:template match="dzial">
		<div class="dzial">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; margin-bottom: 5px; font-variant: small-caps; margin-bottom: 10px;">
				<xsl:value-of select="'Dział'"/>
				<xsl:value-of select="' '"/>
				<xsl:choose>
					<!--<xsl:when test="contains(number(@nr),'NaN')">-->
					<xsl:when test="my:is-number(@nr)">
						<xsl:value-of select="@nr"/>
					</xsl:when>
					<xsl:otherwise >
						<xsl:number value="@nr" format="I"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="'. '"/>
				<xsl:for-each select="tytul">
					<!--<xsl:value-of select="."/>-->
					<xsl:apply-templates/>
				</xsl:for-each>
			</div>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--oddzial-->
	<xsl:template match="oddzial">
		<div class="oddzial">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; margin-bottom: 5px; margin-bottom: 10px;">
				<xsl:value-of select="'Oddział'"/>
				<xsl:value-of select="' '"/>
				<xsl:choose>
					<!--<xsl:when test="contains(number(@nr),'NaN')">-->
					<xsl:when test="my:is-number(@nr)">
						<xsl:value-of select="@nr"/>
					</xsl:when>
					<xsl:otherwise >
						<xsl:number value="@nr"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:for-each select="tytul">
					<br/>
					<xsl:apply-templates/>
				</xsl:for-each>
			</div>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--srodtytul-->
	<xsl:template match="srodtytul">
		<div class="srodtytul">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>

			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!--rozdzial-->
	<xsl:template match="rozdzial">
		<div class="rozdzial">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>
			<div style="text-align: center; font-weight: bold; letter-spacing: 5px; margin-bottom: 5px;">
				<xsl:value-of select="'Rozdział'"/>
				<xsl:value-of select="' '"/>
				<xsl:choose>
					<!--<xsl:when test="contains(number(@nr),'NaN')">-->
					<xsl:when test="my:is-number(@nr)">
						<xsl:value-of select="@nr"/>
					</xsl:when>
					<xsl:otherwise >
						<xsl:number value="@nr" format="I"/>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:for-each select="tytul">
				<div style="text-align: center; font-weight: bold; margin-bottom: 10px;">
					<!--<xsl:value-of select="."/>-->
					<xsl:apply-templates/>
				</div>
			</xsl:for-each>
			<xsl:apply-templates/>
		</div>
	</xsl:template>

	<!-- artykul -->
	<xsl:template match="artykul">
		<xsl:choose>
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="artykul">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<b>
						<xsl:value-of select="'Art.'"/>
						<xsl:value-of select="' '"/>
						<xsl:value-of select="@nr"/>
						<xsl:value-of select="'. '"/>
					</b>
					<xsl:apply-templates/>
				</span>
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="artykul">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<b>
						<xsl:value-of select="'Art.'"/>
						<xsl:value-of select="' '"/>
						<xsl:value-of select="@nr"/>
						<xsl:value-of select="'. '"/>
					</b>
					<xsl:apply-templates/>
				</div>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<!-- paragraf -->
	<xsl:template match="paragraf">
		<xsl:choose>
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="paragraf">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<span style="text-align: left; font-weight: bold;">
						<xsl:value-of select="'§'"/>
						<xsl:value-of select="' '"/>
						<xsl:value-of select="@nr"/>
						<xsl:value-of select="'. '"/>
					</span>
					<xsl:apply-templates/>
				</span>
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="paragraf">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<span style="text-align: left; font-weight: bold;">
						<xsl:value-of select="'§'"/>
						<xsl:value-of select="' '"/>
						<xsl:value-of select="@nr"/>
						<xsl:value-of select="'. '"/>
					</span>
					<xsl:apply-templates/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--ustep-->
	<xsl:template match="ustep">
		<xsl:choose>
			<!--Jezeli jest to pierwszy ustęp-->
			<xsl:when test="position() = 1">
				<span class="ustep">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<xsl:value-of select="@nr"/>
					<xsl:value-of select="'. '"/>
					<xsl:apply-templates/>
				</span>
				<!--Jeżeli w znaczniku nowelizacyjnym to dodaj złamanie linii-->
				<xsl:if test="my:amendments-exists(node())">
					<xsl:if test="position() &lt; last()">
						<br/>
					</xsl:if>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<!--Ustęp w znaczniku nowelizacyjnym-->
					<xsl:when test="my:amendments-exists(node())">
						<span class="ustep">
							<xsl:attribute name="id">
								<xsl:value-of select="@oid"/>
							</xsl:attribute>
							<!--Dla wyrównania dodaję 2 spacje-->
							<xsl:text>&#160;&#160;</xsl:text>
							<xsl:value-of select="@nr"/>
							<xsl:value-of select="'. '"/>
							<xsl:apply-templates/>
						</span>
						<!--Jezeli nie jest to ostatni ustep to dodaj złamanie linii-->
						<xsl:if test="position() &lt; last()">
							<br/>
						</xsl:if>
					</xsl:when>
					<!--Kolejny ustęp poza znaczniukiem nowelizacyjnym-->
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@nr = '1'">
								<!--Jezeli poprzedni element to przypis nowelizacyjny to stosujemy SPAN-->
								<xsl:choose>
									<xsl:when test="name(parent::node()/child::node()[1]) = 'przypis-nowelizacyjny'">
										<span class="ustep">
											<xsl:attribute name="id">
												<xsl:value-of select="@oid"/>
											</xsl:attribute>
											<xsl:value-of select="@nr"/>
											<xsl:value-of select="'. '"/>
											<xsl:apply-templates/>
										</span>
									</xsl:when>
									<xsl:otherwise>
										<div class="ustep">
											<xsl:attribute name="id">
												<xsl:value-of select="@oid"/>
											</xsl:attribute>
											<xsl:value-of select="@nr"/>
											<xsl:value-of select="'. '"/>
											<xsl:apply-templates/>
										</div>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<div class="ustep">
									<xsl:attribute name="id">
										<xsl:value-of select="@oid"/>
									</xsl:attribute>
									<xsl:value-of select="@nr"/>
									<xsl:value-of select="'. '"/>
									<xsl:apply-templates/>
								</div>
							</xsl:otherwise>
						</xsl:choose>


					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- punkt -->
	<xsl:template match="punkt">
		<xsl:choose>
			<!--Punkt w znaczniku nowelizacyjnym-->
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="punkt">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<span>
						<xsl:if test="position() &gt; 1">
							<xsl:text>&#160;&#160;</xsl:text>
						</xsl:if>
						<xsl:value-of select="@nr"/>
						<xsl:value-of select="') '"/>
						<xsl:apply-templates/>
					</span>
				</span>
				<!--Jezeli nie jest to ostatni punkt to dodaj złamanie linii-->
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<!--Punkt znajduje się poza znacznikiem nowelizacyjnym-->
			<xsl:otherwise>
				<div class="punkt">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<table cellpadding="" cellspacing="5" border="0">
						<tr>
							<td style="vertical-align: top;">
								<xsl:value-of select="@nr"/>
								<xsl:value-of select="') '"/>
							</td>
							<td style="vertical-align: top;">
								<xsl:apply-templates/>
							</td>
						</tr>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- litera -->
	<xsl:template match="litera">
		<xsl:choose>
			<!--Litera w znaczniku nowelizacyjnym-->
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="litera">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<span>
						<xsl:if test="position() &gt; 1">
							<xsl:text>&#160;&#160;</xsl:text>
						</xsl:if>
						<xsl:value-of select="@nr"/>
						<xsl:value-of select="') '"/>
						<xsl:apply-templates/>
					</span>
				</span>
				<!--Jezeli nie jest to ostatnia litera to dodaj złamanie linii-->
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="litera">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<table cellpadding="" cellspacing="5" border="0">
						<tr>
							<td style="vertical-align: top;">
								<xsl:value-of select="@nr"/>
								<xsl:value-of select="') '"/>
							</td>
							<td style="vertical-align: top;">
								<xsl:apply-templates/>
							</td>
						</tr>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- wielka-litera -->
	<xsl:template match="wielka-litera">
		<xsl:choose>
			<!--Litera w znaczniku nowelizacyjnym-->
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="wielka-litera">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<span>
						<xsl:if test="position() &gt; 1">
							<xsl:text>&#160;&#160;</xsl:text>
						</xsl:if>
						<span style="font-weight: bold;">
							<xsl:value-of select="@nr"/>
							<xsl:value-of select="'. '"/>
						</span>
						<xsl:apply-templates/>
					</span>
				</span>
				<!--Jezeli nie jest to ostatnia litera to dodaj złamanie linii-->
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="wielka-litera">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<table cellpadding="" cellspacing="5" border="0">
						<tr>
							<td style="vertical-align: top; font-weight: bold;">
								<xsl:value-of select="@nr"/>
								<xsl:value-of select="'. '"/>
							</td>
							<td style="vertical-align: top;">
								<xsl:apply-templates/>
							</td>
						</tr>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- cyfra-rzymska -->
	<xsl:template match="cyfra-rzymska">
		<xsl:choose>
			<!--Litera w znaczniku nowelizacyjnym-->
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="cyfra-rzymska">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<span>
						<xsl:if test="position() &gt; 1">
							<xsl:text>&#160;&#160;</xsl:text>
						</xsl:if>
						<span style="font-weight: bold;">
							<xsl:value-of select="@nr"/>
							<xsl:value-of select="'. '"/>
						</span>
						<xsl:apply-templates/>
					</span>
				</span>
				<!--Jezeli nie jest to ostatnia litera to dodaj złamanie linii-->
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="cyfra-rzymska">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<table cellpadding="" cellspacing="5" border="0">
						<tr>
							<td style="vertical-align: top; font-weight: bold;">
								<xsl:value-of select="@nr"/>
								<xsl:value-of select="'. '"/>
							</td>
							<td style="vertical-align: top;">
								<xsl:apply-templates/>
							</td>
						</tr>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- tiret -->
	<xsl:template match="tiret">
		<xsl:choose>
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="tiret">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<table cellpadding="" cellspacing="5" border="0">
						<tr>
							<td style="vertical-align: top;">
								<xsl:value-of select="'-'"/>
								<xsl:value-of select="' '"/>
							</td>
							<td style="vertical-align: top;">
								<xsl:apply-templates/>
							</td>
						</tr>
					</table>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<div class="tiret">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<table cellpadding="" cellspacing="5" border="0">
						<tr>
							<td style="vertical-align: top;">
								<xsl:value-of select="'-'"/>
								<xsl:value-of select="' '"/>
							</td>
							<td style="vertical-align: top;">
								<xsl:apply-templates/>
							</td>
						</tr>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--akapit-->
	<xsl:template match="akapit">
		<xsl:choose>
			<xsl:when test="my:amendments-exists(node())">
				<xsl:if test="my:amendments-is-parent(node()) = false()">
					<br/>
				</xsl:if>
				<span class="akapit">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</span>
				<!--Jezeli nie jest to ostatni akapit to dodaj złamanie linii-->
				<xsl:if test="position() &lt; last()">
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="akapit">
					<xsl:attribute name="id">
						<xsl:value-of select="@oid"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</div>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:template>

	<!--Znaczniki nowelizacyjne-->
	<xsl:template match="zastap">
		<div class="zastap">
			<blockquote>
				&#8222;
				<xsl:apply-templates/>
				&#8221;
			</blockquote>
		</div>
	</xsl:template>
	<xsl:template match="dodaj">
		<div class="dodaj">
			<blockquote>
				&#8222;
				<xsl:apply-templates/>
				&#8221;
			</blockquote>
		</div>
	</xsl:template>
	<!--Nic nie robimy z zawartością uchylanego elementu-->
	<xsl:template match="uchyl"/>

	<xsl:template match="cytowanie">
		<div class="cytowanie">
			<blockquote>
				&#8222;
				<xsl:apply-templates/>
				&#8221;
			</blockquote>
		</div>
	</xsl:template>

	<!--F O R M A T O W A N I E-->
	<!--Wytłuszczenie-->
	<xsl:template match="wytluszczenie">
		<b>
			<xsl:apply-templates/>
		</b>
	</xsl:template>
	<!--Podkreslenie-->
	<xsl:template match="podkreslenie">
		<u>
			<xsl:apply-templates/>
		</u>
	</xsl:template>
	<!--Kursywa-->
	<xsl:template match="kursywa">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!--indeks dolny-->
	<xsl:template match="indeks-dolny">
		<sub>
			<xsl:apply-templates/>
		</sub>
	</xsl:template>
	<!--indeks gorny-->
	<xsl:template match="indeks-gorny">
		<sup>
			<xsl:apply-templates/>
		</sup>
	</xsl:template>
	<!--Link-->
	<xsl:template match="link">
		<xsl:choose>
			<xsl:when test="@typ = 'zalacznik'">
				<div style="width: 100%; margin-top: 10px; margin-bottom: 10px; text-align: center;">
					<img style="border: 0px;" alt="">
						<xsl:attribute name="src">
							<xsl:value-of select="@cel"/>
						</xsl:attribute>
					</img>
				</div>
			</xsl:when>
			<xsl:otherwise >
				<a target="_blank">
					<xsl:attribute name="href">
						<xsl:value-of select="@cel"/>
					</xsl:attribute>
					<xsl:apply-templates/>
				</a>
			</xsl:otherwise>
		</xsl:choose>


	</xsl:template>

	<!--T A B E L A-->
	<xsl:template match="tabela">
		<table class="tabela">
			<xsl:attribute name="id">
				<xsl:value-of select="@oid"/>
			</xsl:attribute>

			<xsl:attribute name="cellpadding">
				<xsl:value-of select="@odleglosc-akapitu"/>
			</xsl:attribute>
			<xsl:attribute name="cellspacing">
				<xsl:value-of select="@szerokosc-krawedzi"/>
			</xsl:attribute>
			<xsl:attribute name="width">
				<xsl:value-of select="@szerokosc"/>
				<xsl:value-of select="'%'"/>
			</xsl:attribute>
			<xsl:for-each select="wiersz">
				<tr class="wiersz">
					<xsl:for-each select="komorka">
						<td class="komorka">
							<xsl:if test="@scal-poziomo != ''">
								<xsl:attribute name="colspan">
									<xsl:value-of select="@scal-poziomo"/>
								</xsl:attribute>
							</xsl:if>
							<xsl:if test="@scal-pionowo != ''">
								<xsl:attribute name="rowspan">
									<xsl:value-of select="@scal-pionowo"/>
								</xsl:attribute>
							</xsl:if>
							<xsl:if test="@wyrownanie != ''">
								<xsl:attribute name="align">
									<xsl:choose>
										<xsl:when test="@wyrownanie = 'do-lewej'">
											<xsl:value-of select="'left'"/>
										</xsl:when>
										<xsl:when test="@wyrownanie = 'do-prawej'">
											<xsl:value-of select="'right'"/>
										</xsl:when>
										<xsl:when test="@wyrownanie = 'wysrodkowanie'">
											<xsl:value-of select="'center'"/>
										</xsl:when>
										<xsl:when test="@wyrownanie = 'wyjustowanie'">
											<xsl:value-of select="'justify'"/>
										</xsl:when>
									</xsl:choose>
								</xsl:attribute>
							</xsl:if>
							<xsl:if test="@szerokosc != ''">
								<xsl:attribute name="width">
									<xsl:value-of select="@szerokosc"/>
									<xsl:value-of select="'%'"/>
								</xsl:attribute>
							</xsl:if>

							<xsl:apply-templates/>
						</td>
					</xsl:for-each>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>

	<!--Przypisy-->
	<xsl:template match="przypis">
		<sup>
			<a style="color: black; text-decoration: none; font-weight: normal;">
				<xsl:attribute name="href">
					<xsl:value-of select="'#przypis'"/>
					<xsl:value-of select="@nr"/>
				</xsl:attribute>
				<xsl:apply-templates/>
			</a>
		</sup>
	</xsl:template>

	<xsl:template match="przypis-nowelizacyjny">
		<sup>
			<a style="color: black; text-decoration: none; font-weight: normal;">
				<xsl:attribute name="href">
					<xsl:value-of select="@cel"/>
				</xsl:attribute>
				<xsl:attribute name="title">
					<xsl:choose>
						<xsl:when test="@status= 'zastap'">
							<xsl:text>Zmiana: </xsl:text>
						</xsl:when>
						<xsl:when test="@status = 'dodaj'">
							<xsl:text>Dodany: </xsl:text>
						</xsl:when>
						<xsl:when test="@status = 'uchyl'">
							<xsl:text>Uchylony: </xsl:text>
						</xsl:when>
					</xsl:choose>

					<xsl:value-of select="@nazwa"/>
				</xsl:attribute>
				<xsl:text>(</xsl:text>
				<xsl:value-of select="@nr"/>
				<xsl:text>)</xsl:text>
			</a>
		</sup>
	</xsl:template>

	<!--Nowa linia-->
	<xsl:template match="nl">
		<br/>
	</xsl:template>

	<!-- te które są implementowane wyjątkowow inaczej -->
	<xsl:template match="tresc-przypisow"/>
	<xsl:template match="metryczka"/>
	<xsl:template match="podpisy"/>
	<xsl:template match="zalaczniki"/>
	<xsl:template match="zalacznik_bin"/>
	<xsl:template match="tytul"/>
	<xsl:template match="podpis"/>
	<xsl:template match="zatwierdzil"/>
	<xsl:template match="ds:Signature"/>
	<xsl:template match="uzasadnienie"/>
	<xsl:template match="lista"/>
	<xsl:template match="osoba"/>
	<xsl:template match="tresc-przypisow-nowelizacyjnych"/>
	<xsl:template match="lista-aktow-zmieniajacych"/>
	<!-- // te które są implementowane wyjątkowow inaczej -->

	<xsl:function name="my:is-number" as="xs:boolean">
		<xsl:param name="arg" as="xs:string"/>
		<xsl:sequence select="matches($arg, '\d+')"/>
	</xsl:function>

	<xsl:function name="my:amendments-is-parent" as="xs:boolean">
		<xsl:param name="context-node"/>
		<xsl:value-of select="(name($context-node/parent::node()/parent::node()) = 'elementem') or (name($context-node/parent::node()/parent::node()) = 'element') or (name($context-node/parent::node()/parent::node()) = 'cytowanie')"/>
	</xsl:function>

	<xsl:function name="my:amendments-exists" as="xs:boolean">
		<xsl:param name="context-node" />
		<xsl:value-of select="my:parent-exists($context-node,'elementem') or my:parent-exists($context-node,'element') or my:parent-exists($context-node,'cytowanie') "/>
	</xsl:function>

	<xsl:function name="my:parent-exists" as="xs:boolean">
		<xsl:param name="context-node" />
		<xsl:param name="parent-name" as="xs:string"/>

		<!--<xsl:sequence select="exists(name($context-node/ancestor::*) = $parent-name)"/>-->
		<xsl:choose>
			<xsl:when test="contains(my:__parent-exists($context-node,$parent-name), 'true')">
				<xsl:value-of select="true()"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="false()"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>

	<xsl:function name="my:__parent-exists" as="xs:string?">
		<xsl:param name="context-node" />
		<xsl:param name="parent-name" as="xs:string"/>

		<!--czy rodzić istnieje-->
		<xsl:for-each select="$context-node/ancestor::*">
			<xsl:choose>
				<xsl:when test="name() = $parent-name">
					<xsl:value-of select="'true'"/>
				</xsl:when>
				<!--<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>-->
			</xsl:choose>
		</xsl:for-each>
	</xsl:function>

	<xsl:template name="date-year">
		<xsl:param name="ADate"/>

		<xsl:value-of select="substring($ADate,1,4)"/>
		<xsl:value-of select="' r.'"/>
	</xsl:template>

	<xsl:template name="date-name">
		<xsl:param name="ADate"/>
		<xsl:choose>
			<xsl:when test="substring($ADate,9,1)='0'">
				<xsl:value-of select="substring($ADate,10,1)"/>
			</xsl:when>
			<xsl:when test="substring($ADate,9,1)!='0'">
				<xsl:value-of select="substring($ADate,9,2)"/>
			</xsl:when>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="substring($ADate,6,2)='01'">
				<xsl:value-of select="' stycznia '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='02'">
				<xsl:value-of select="' lutego '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='03'">
				<xsl:value-of select="' marca '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='04'">
				<xsl:value-of select="' kwietnia '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='05'">
				<xsl:value-of select="' maja '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='06'">
				<xsl:value-of select="' czerwca '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='07'">
				<xsl:value-of select="' lipca '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='08'">
				<xsl:value-of select="' sierpnia '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='09'">
				<xsl:value-of select="' września '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='10'">
				<xsl:value-of select="' października '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='11'">
				<xsl:value-of select="' listopada '"/>
			</xsl:when>
			<xsl:when test="substring($ADate,6,2)='12'">
				<xsl:value-of select="' grudnia '"/>
			</xsl:when>
		</xsl:choose>
		<xsl:value-of select="substring($ADate,1,4)"/>
		<xsl:value-of select="' r.'"/>
	</xsl:template>
	<xsl:template name="replace-string">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="with"/>
		<xsl:choose>
			<xsl:when test="contains($text,$replace)">
				<xsl:value-of select="substring-before($text,$replace)"/>
				<xsl:value-of select="$with"/>
				<xsl:call-template name="replace-string">
					<xsl:with-param name="text" select="substring-after($text,$replace)"/>
					<xsl:with-param name="replace" select="$replace"/>
					<xsl:with-param name="with" select="$with"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="left-trim">
		<xsl:param name="s" />

		<xsl:choose>
			<xsl:when test="normalize-space(substring($s, 1, 1)) = ''">
				<xsl:call-template name="left-trim">
					<xsl:with-param name="s" select="substring($s, 2)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$s" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="right-trim">
		<xsl:param name="s" />

		<xsl:choose>
			<xsl:when test="normalize-space(substring($s, string-length($s))) = ''">
				<xsl:call-template name="right-trim">
					<xsl:with-param name="s" select="substring($s, 1, string-length($s) - 1)" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$s" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="trim">
		<xsl:param name="text" />
		<xsl:variable name="s1">
			<xsl:call-template name="right-trim">
				<xsl:with-param name="s" select="$text" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="left-trim">
			<xsl:with-param name="s" select="$s1" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="text()">
		<xsl:call-template name="break"/>
	</xsl:template>

	<xsl:template name="break">
		<xsl:param name="text" select="."/>
		<xsl:choose>
			<xsl:when test="contains($text, '|')">
				<xsl:value-of select="substring-before($text, '|')"/>
				<br/>
				<xsl:call-template name="break">
					<xsl:with-param name="text" select="substring-after($text,'|')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
